/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.modernui.util.Pool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Pools {
    private Pools() {
    }

    @Nonnull
    public static <T> Pool<T> simple(int maxPoolSize) {
        return new SimplePool(maxPoolSize);
    }

    @Nonnull
    public static <T> Pool<T> concurrent(int maxPoolSize) {
        return new SynchronizedPool(maxPoolSize);
    }

    private static class SynchronizedPool<T>
    extends SimplePool<T> {
        private SynchronizedPool(int maxPoolSize) {
            super(maxPoolSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T acquire() {
            SynchronizedPool synchronizedPool = this;
            synchronized (synchronizedPool) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(@Nonnull T element) {
            SynchronizedPool synchronizedPool = this;
            synchronized (synchronizedPool) {
                return super.release(element);
            }
        }
    }

    private static class SimplePool<T>
    implements Pool<T> {
        private final T[] mPool;
        private int mPoolSize;

        private SimplePool(int maxPoolSize) {
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[maxPoolSize];
        }

        @Override
        @Nullable
        public T acquire() {
            if (this.mPoolSize <= 0) {
                return null;
            }
            int lastPooledIndex = this.mPoolSize - 1;
            T instance = this.mPool[lastPooledIndex];
            this.mPool[lastPooledIndex] = null;
            --this.mPoolSize;
            return instance;
        }

        @Override
        public boolean release(@Nonnull T instance) {
            if (this.isInPool(instance)) {
                throw new IllegalStateException("Already in the pool!");
            }
            if (this.mPoolSize >= this.mPool.length) {
                return false;
            }
            this.mPool[this.mPoolSize] = instance;
            ++this.mPoolSize;
            return true;
        }

        private boolean isInPool(@Nonnull T instance) {
            for (int i = 0; i < this.mPoolSize; ++i) {
                if (this.mPool[i] != instance) continue;
                return true;
            }
            return false;
        }
    }
}

